<?php

class Text_To_Speech
{
  private $TTS_Manager;

  public function __construct()
  {
    $this->TTS_Manager = new Ultimate_AI_TTS();
    
    add_action("wp_ajax_ultimate_ai_ttsapi", array($this, "ultimate_ai_text_to_speech_controller"));
    add_action('wp_ajax_ultimate_ai_get_elevenlabs_voices', [$this, 'ultimate_ai_get_elevenlabs_voices']);
    
    register_activation_hook(ULTIMATE_AI_PLUGIN_ROOT . 'ultimate_ai.php', [$this, 'run_regiser_activation_methods']);
  }
  public function run_regiser_activation_methods()
  {
    $this->run_user_meta_updater();
  }

  public function run_user_meta_updater()
  {
    $User_Manager = new Ultimate_AI_User_Manager();
    if ($User_Manager->is_new_version_available()) {
      $User_Manager->migrate_user_meta_to_new_structure();
    }
  }

  public function ultimate_ai_get_elevenlabs_voices()
  {
    $res = $this->TTS_Manager->elevenlabs_get_voices();
    wp_send_json($res, 200);
  }

  public function ultimate_ai_text_to_speech_controller()
  {
    $open_api = new UltimateAI_OpenAI_API_Manager();
    $open_ai_controller = new UltimateAI_OpenAI_Controller();

    $res_json = $open_ai_controller->restrict_user_by_token("tts");
    if ($res_json) {
      wp_send_json(json_decode($res_json), 401);
    }

    $text_data = $_POST['voice_data'];
    $text = $text_data['text'];
    $voice = $text_data['voice_id'];
    $ai_model = $text_data['ai_model'];
    $res = [
      'text' => $text,
      ''
    ];

    if( $ai_model == 'openai' ){
      $res = $open_api->get_text_to_speech_api_result( $text, $voice );
    }
    if( $ai_model == 'elevenlabs' ){
      $res = $this->TTS_Manager->elevenlabs_create_voice($text_data);
    }
    wp_send_json($res, 200);
  }
}

new Text_To_Speech();
